<?php

/**
 * This is the model class for table "SzkoleniePytaniaEgzamin".
 *
 * The followings are the available columns in table 'SzkoleniePytaniaEgzamin':
 * @property double $id
 * @property double $idSzkolenia
 * @property string $tresc
 * @property string $urlObrazka
 */
class SzkoleniePytaniaEgzamin extends CActiveRecord
{
	public $image;
	public $tempFolderName;
	public $tempImageName;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SzkoleniePytaniaEgzamin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'SzkoleniePytaniaEgzamin';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idSzkolenia', 'numerical'),
			array('urlObrazka', 'safe'),
			array('tresc', 'length', 'max'=>2000),
			array('tresc', 'required'),
			array('image', 'file', 'safe' => true, 'types'=>'jpg, gif, png', 'allowEmpty'=>true),
			array('tempFolderName,tempImageName', 'safe'),

			array('id, idSzkolenia, tresc', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'szkolenie'=>array(self::BELONGS_TO, 'Szkolenie', 'idSzkolenia'),
			'szkoleniePytaniaEgzamins'=>array(self::HAS_MANY, 'SzkoleniePytaniaEgzamin', 'idPytania'),
			'odpowiedzi'=>array(self::HAS_MANY, 'SzkolenieOdpowiedziEgzamin', 'idPytania'),
			'szkolenieOdpowiedziFirmies'=>array(self::HAS_MANY, 'SzkolenieOdpowiedziFirmy', 'idPytania'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('SzkoleniePytaniaEgzamin', 'id'),
			'idSzkolenia'=>Yii::t('SzkoleniePytaniaEgzamin', 'idSzkolenia'),
			'tresc'=>Yii::t('SzkoleniePytaniaEgzamin', 'tresc'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idSzkolenia', $this->idSzkolenia);
		$criteria->compare('tresc', $this->tresc, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}